function value_authoritarian = Authoritarian(x,par)

%%% Calculate welfare when the upper bound to consumption of the social
%%% good equals x

%% parameters
T = par.T;    %(1 period is a week), so solve for T weeks
dt = par.dt;
beta = par.beta;     %dicounting
phi = par.phi; 
nphi = par.nphi;
g = par.g;  %density phi
epsilon = par.epsilon;     %fraction infected initially
alpha = par.alpha;
As = par.As;   %set A_s such that P_s is 1 in economy with no infections (Ar=L=1)

%disease parameters
p = par.p;
lambda_R = par.lambda_R;
lambda_D = par.lambda_D;

%steady state values
B_ss = par.B_ss;  %Ps=1,L=1,Ar=1
cr_ss = par.cr_ss;
cs_ss = par.cs_ss;
CS_ss = par.CS_ss;

d_CS = par.d_CS;

a = par.a;
b = par.b;

degree_ss = b+a*cs_ss*(CS_ss.^(d_CS));
degree_ss_exp = degree_ss*g';

value_life = par.value_life;    %B_ss is income per capita per week. 10 qaly (= 1 million dollar) corresponds to 16 times GDP per capita
u_lowerbar = (1-beta)*value_life/B_ss - log(B_ss);


%% construct the grid
dS = 0.025;
S_grid = 0:dS:1;     

dI = 0.03; 
I_grid = 0:dI:0.3; 

T_grid = 1:dt:T;

nS = length(S_grid);    %make sure nS  = nR
nI = length(I_grid);
nT = length(T_grid);

xs_grid = 0.01:(1.04/440):1.05;   %share of phi spent on social good

[I_mat,S_mat,XS_mat] = meshgrid(I_grid,S_grid,xs_grid);
I_tmp = I_mat(:,:,1);
S_tmp = S_mat(:,:,1);

alive = min(1-(1-S_mat - I_mat)*lambda_D/(lambda_D+lambda_R),1); 
Itilde_mat = I_mat./alive;


%% value function iteration
%initialize disease states (for forward simulation)
S_phi = NaN(nT,nphi);
S_phi(1,:) = (1-epsilon*degree_ss/degree_ss_exp); %reflects that those with a higher degree are more likely to be infected
I_phi = NaN(nT,nphi);
I_phi(1,:) = epsilon*degree_ss/degree_ss_exp;
cs_eq = NaN(nT,nphi);   %consumption of social good over time for each type
iter1 = 0;
gamma = 1;    %update rate time variables, homothopy
gammaP = 0.2;  

pol = par.pol;  
x = [x 0.24];   %last period no constraint
%construct the policy (for each period)
kappa = NaN(1,nT);
t2 = 0;
for i_p = 1:length(pol)
    t1 = t2+1;
    t2 = t1 + pol(i_p) - 1;
    kappa(t1:t2) = x(i_p);    
end

% initial guess
f = [0.0251223102962138 0.0308152302547314 0.0369699533434332 0.0432912760862277 0.0495906309625441 0.0555591106889006 0.0610313875717742 0.0658219750043719 0.0697983263070131 0.0729528722034717 0.0752327725730246 0.0767179326536773 0.0774473068761795 0.0774274841705069 0.0768113506706879 0.0756475297785772 0.0740691132516966 0.0721105349165939 0.0698615679233679 0.0674236919682386 0.0641073521071281 0.0606017906162210 0.0570892239322960 0.0536285494725810 0.0500736047015785 0.0466473576122813 0.0433964667509433 0.0403563924592307 0.0375165973774968 0.0348585545529239 0.0324910137939198 0.0303464325249295 0.0283292986687644 0.0264492891632319 0.0246858659626043 0.0230455438452438 0.0215509631913809 0.0201965466906154 0.0189261005657145 0.0177372657393247 0.0166258754768044 0.0155849493277201 0.0146195812335187 0.0137206382330596 0.0128779194439913 0.0120916532652165 0.0113534687610851 0.0106665790007125 0.0100232210554544 0.00942211763202401 0.00886024265659072 0.00833289877511816 0.00784684621670986 0.00745977765573964 0.00709026125065451 0.00673810425014137 0.00640465146448501 0.00608843454931517 0.00578646113437898 0.00550114601060067 0.00522994002799100 0.00497160433211684 0.00472981464199816 0.00452683648625764 0.00433223854568890 0.00414556862668417 0.00396626391272372 0.00379531788706796 0.00363108911068042 0.00347426556347358 0.00332403908330806 0.00318006403445993 0.00304308185960058 0.00291178703051902 0.00278602743336181 0.00266484728742163 0.00254885105786762 0.00243785131274757 0.00233246753920747 0.00224793322167350 0.00216584080152820 0.00208673577626716 0.00200998680518569 0.00193614142457485 0.00186450872613065 0.00179560338499225 0.00172927611780702 0.00166508763455908 0.00160337097125077 0.00154423221552055 0.00148696230532012 0.00143187276416190 0.00137864665099184 0.00132745951578854 0.00127803581152738 0.00123051724565681 0.00118457965583512 0.00114026913840456 0.00109855964531643 0.00107110385383071 0.00104416266900158 0.00101784428568357 0.000992023012523915 0.000966912410275055 0.000942309216308164 0.000918194622250354 0.000894681508127820 0.000871640972759665 0.000849299680201515 0.000827699614078350 0.000806556795693967 0.000785851900823059 0.000765673387663495 0.000746059952483552 0.000726887171841338 0.000708139235503238 0.000689810775116687 0.000671882207076018 0.000654446108934897 0.000637401886946350 0.000620852956417189 0.000604688568860787 0.000588900602341984 0.000573483049914582 0.000558429883595604 0.000543723084551949 0.000529444513982740 0.000515502719258845 0.000501974157056163 0.000488772455280316 0.000475890928615790 0.000463323376892309 0.000451063572572354 0.000439105289666751 0.000427442356385225 0.000416059198010623 0.000405018088548175 0.000394302120589963 0.000383855986115408 0.000373669302376144 0.000363736419400164 0.000354051643337461 0.000344609384246199 0.000335404154902190 0.000326430577082581 0.000317683379390236 0.000309157393471925 0.000300840718688353 0.000292780622775254 0.000284925003457692 0.000277303838401511 0.000269874659803477 0.000262632751188950 0.000255573601375142 0.000248692810280631 0.000241986037477787 0.000235449008650892 0.000229077485159735 0.000222867301906502 0.000216814304629248 0.000210914411237273 0.000205163642710027 0.000199558100318669 0.000194093913110304 0.000188767369745359 0.000183575135764025 0.000178509959520558 0.000173599357952427 0.000168829048431474 0.000164175684129150 0.000159635954665179 0.000155206779571018 0.000150885019939430 0.000146667704370495 0.000142552062264194 0.000138535201232885 0.000134614559344163 0.000130787400500110 0.000127051381750815 0.000123403907901709 0.000119842875772360 0.000116365821036193 0.000112970899727427 0.000109655761117659 0.000106418841578584 0.000103257877523162 0.000100171639267525 9.71586164350532e-05 9.42174870240311e-05 9.13457428670748e-05 8.85433047674763e-05 8.58162824334836e-05 8.31767098826974e-05 8.05974133399347e-05 7.80982425975109e-05 7.56576321051001e-05 7.32744723088142e-05 7.09477221328671e-05 6.86824046791711e-05]';
L = [1 0.999975000000000 0.999944688996174 0.999908624774063 0.999866594992574 0.999818609540117 0.999764877780495 0.999705831918648 0.999642032487532 0.999574169873930 0.999503013389893 0.999429332735165 0.999353866745661 0.999277333705860 0.999200404199311 0.999123696247886 0.999047739190046 0.998972958420343 0.998899738805255 0.998828384609210 0.998759108011963 0.998692101734551 0.998628076803668 0.998567126003553 0.998509279131867 0.998454519032276 0.998402964100795 0.998354518098083 0.998309057029506 0.998266429875187 0.998226502911262 0.998189136694261 0.998154036750596 0.998121083138246 0.998090150604511 0.998061128086097 0.998033897994593 0.998008350805122 0.997984323172164 0.997961726578708 0.997940472045350 0.997920481204843 0.997901679943355 0.997883990336048 0.997867339752053 0.997851668449959 0.997836914767107 0.997823026969160 0.997809949225541 0.997797633154580 0.997786031442646 0.997775100306215 0.997764800860851 0.997755093337864 0.997745876079535 0.997737121256391 0.997728803496397 0.997720897269933 0.997713379105177 0.997706230726409 0.997699431265358 0.997692962817355 0.997686809597738 0.997680954061213 0.997675356354691 0.997670002986466 0.997664882081802 0.997659983361055 0.997655295930830 0.997650810674195 0.997646517769157 0.997642408817611 0.997638476132305 0.997634711350333 0.997631107389142 0.997627657472100 0.997624356176062 0.997621197109860 0.997618174147675 0.997615281382771 0.997612498229712 0.997609820104668 0.997607242045913 0.997604760313547 0.997602370627656 0.997600069855940 0.997597854214341 0.997595720288716 0.997593665341602 0.997591686266862 0.997589780034051 0.997587944288175 0.997586176245839 0.997584473591141 0.997582833767661 0.997581254615210 0.997579733778527 0.997578269373735 0.997576859409194 0.997575501752043 0.997574182940499 0.997572900933585 0.997571653898902 0.997570440427321 0.997569259036062 0.997568108698066 0.997566988495328 0.997565897450232 0.997564834799789 0.997563799605955 0.997562790950027 0.997561808194650 0.997560850729137 0.997559917827846 0.997559008759801 0.997558122988127 0.997557259996277 0.997556419275232 0.997555600323242 0.997554802527837 0.997554025404948 0.997553268343955 0.997552530895399 0.997551812615715 0.997551113065655 0.997550431811018 0.997549768423217 0.997549122372766 0.997548493249188 0.997547880545966 0.997547283881052 0.997546702876901 0.997546137160772 0.997545586365419 0.997545050129586 0.997544528098309 0.997544019923251 0.997543525168876 0.997543043437846 0.997542574414199 0.997542117791479 0.997541673267832 0.997541240546623 0.997540819336716 0.997540409352667 0.997540010314823 0.997539621949372 0.997539243988351 0.997538876169465 0.997538518171043 0.997538169744035 0.997537830600117 0.997537500512216 0.997537179257270 0.997536866616410 0.997536562375139 0.997536266323504 0.997535978256196 0.997535697972643 0.997535425277027 0.997535159978342 0.997534901890371 0.997534650831602 0.997534406625164 0.997534169098821 0.997533938084799 0.997533713419349 0.997533494942443 0.997533282455849 0.997533075787573 0.997532874799289 0.997532679355584 0.997532489323950 0.997532304575071 0.997532124982777 0.997531950423919 0.997531780778606 0.997531615929869 0.997531455763922 0.997531300169725 0.997531149039315 0.997531002267231 0.997530859750967 0.997530721390231 0.997530587087572 0.997530456747423 0.997530330276963 0.997530207584872 0.997530088581667 0.997529973179452 0.997529861293386 0.997529752838791 0.997529647727970 0.997529545859844 0.997529447154046 0.997529351505501 0.997529258843271 0.997529169097596 0.997529082199855]';
Ps = [0.920433382842294 0.907515267833911 0.894324589163787 0.882196022602659 0.871303201542043 0.861442090658746 0.853259647694604 0.846340569694859 0.840670528454412 0.836456965738619 0.833741569666438 0.831886460110434 0.830887996795485 0.830654695164493 0.831302436996938 0.833030082837570 0.834880766361760 0.837395722234798 0.840794565913359 0.843994614606443 0.837976009665634 0.841116568820549 0.844565988144589 0.848203047030372 0.847859662511099 0.851666711386780 0.855533258843399 0.860086579213087 0.863711765397274 0.867283640660000 0.876944879885126 0.880125521933344 0.883514386805025 0.886444180252983 0.889681280755426 0.892743945042797 0.899443267455388 0.901961837355084 0.904651032823585 0.906828890850132 0.909076633220949 0.911703480128670 0.914393374246369 0.916107959846402 0.918284807423805 0.919747245738208 0.921861403875254 0.923572818913042 0.925192177301045 0.926887924995417 0.928104102613171 0.929782165014959 0.943603351574065 0.944399770381224 0.945192116394708 0.946437931399364 0.947451456078797 0.948005896263654 0.949238899508578 0.950014214418926 0.950602395479448 0.951765975790016 0.960267861473491 0.960851914542985 0.961384199137461 0.961762506654672 0.962582057059981 0.962956560352714 0.963588385503670 0.964056779889908 0.964432634949459 0.965245667979013 0.965614338152055 0.965967135861206 0.966016505282147 0.966376246907752 0.966735140372234 0.967101980069083 0.976596804484666 0.976638654555437 0.976971067280302 0.977005940914965 0.977363070898166 0.977371805788225 0.977729462226248 0.978020522671948 0.978093525963736 0.978374621334385 0.978882702829542 0.978894246573763 0.979171642085187 0.979255522076790 0.979523024749984 0.979613395325850 0.979859700600248 0.979876890098478 0.979978294545769 0.980223125528912 0.995102478387053 0.995103352543183 0.995213027696081 0.995219763463183 0.995443088159543 0.995446946263222 0.995446968799802 0.995566347138628 0.995577511824277 0.995786182582200 0.996208910298118 0.996208962565377 0.996209064664627 0.996347021573587 0.996500510829412 0.996549860588516 0.996551665704382 0.996551750986550 0.996551867714190 0.996667070433067 0.996708429961641 0.996882449940404 0.996894227903076 0.996894337991754 0.996894358843042 0.996894517132854 0.996894900289622 0.997033663067336 0.997066339321633 0.997232889884015 0.997236642086805 0.997236796773551 0.997236889312966 0.997237040679913 0.997237367311187 0.997238177355952 0.997238913473559 0.997421822128381 0.997540846611506 0.997578878494708 0.997579004928790 0.997579232562714 0.997579330242601 0.997579585859677 0.997579998653113 0.997580579996454 0.997581384116763 0.997582511081099 0.997585534245003 0.997719438319842 0.997781108499476 0.997921014960554 0.997921194104375 0.997921325464985 0.997921566129698 0.997921893873786 0.997922159166866 0.997922546605493 0.997922933399205 0.997923712146270 0.997924353444715 0.997925112911046 0.997926642397831 0.997929218767139 0.997932219909601 0.997937006606146 0.997948590781279 0.997970242796608 0.998149976132315 0.998264954021555 0.998266094561059 0.998266141178995 0.998267740681593 0.998267804652223 0.998267803172286 0.998270134883782 0.998270133471382 0.998273274862336 0.998273397153004 0.998277798020709 0.998277967503250 0.998284130996209 0.998284367122126 0.998293000089316 0.998293327637330 0.998305417934874 0.998305873307792 0.998323439129849 0.998347147070148 0.998381227197615 0.998382458982257 0.998430658000813 0.998589250708571 0.998736427864789 0.998822942600114 0.999020851808559 0.999020850893633 0.999020850000293 0.999020849127949 0.999020848276109 0.999854621518780]';

%calculate Ps with constraint. cs_comp is cs_eq' from competitive 
cs_comp = [0.0539670960284892 0.0514181551355674 0.0488387724655728 0.0467072993961064 0.0446679209713930 0.0431116628124018 0.0417451768435569 0.0406738964049103 0.0398571793150665 0.0391509665395897 0.0387625255331846 0.0384750009316593 0.0382920989332564 0.0383387798642015 0.0383912573003355 0.0386553937540854 0.0389177379567121 0.0393096785333680 0.0398539810024035 0.0403644709783490 0.0419163608741247 0.0428313089188807 0.0438628437499963 0.0449661744844782 0.0464659689716767 0.0476279915569680 0.0488684404805540 0.0500311451304894 0.0511390861194383 0.0522309078008200 0.0528858564333674 0.0538524490373328 0.0549002734214752 0.0557783550350935 0.0567747844664315 0.0576902074927550 0.0582643007734713 0.0590016986273645 0.0598086853056628 0.0606388154873218 0.0612793862664473 0.0620672093421737 0.0626668197755699 0.0633218484641356 0.0639421410477112 0.0645037396575570 0.0651022464065572 0.0655475559589493 0.0661708027016123 0.0666108751066642 0.0670797272626674 0.0675155064948930 0.0669803830746609 0.0672936557762974 0.0676057487331054 0.0678869095882111 0.0682984970414124 0.0685052418048699 0.0687829789094088 0.0690895015073140 0.0693210101725998 0.0695925435740874 0.0692108672884803 0.0694539635541591 0.0696581360812589 0.0698083573939618 0.0699292713774478 0.0700789988954109 0.0703448382976198 0.0705229492011208 0.0706715357843667 0.0707908860253367 0.0709393068518915 0.0710884975351114 0.0710978013743991 0.0712422557256197 0.0713856309006117 0.0715329177732702 0.0710710434092610 0.0710773349740673 0.0712133073184582 0.0712261159635977 0.0713722056685579 0.0713744549019637 0.0715202078464064 0.0716442649508968 0.0716678763319925 0.0717874635446160 0.0717870811006433 0.0717885773724336 0.0719013982633872 0.0719353216503347 0.0720445385455362 0.0720818921127699 0.0721885573853741 0.0721874552124189 0.0722293568138044 0.0723307465892988 0.0713620900954994 0.0713620632771675 0.0714091566455492 0.0714101991277443 0.0715042413508556 0.0715040201123251 0.0715040440715801 0.0715573582261250 0.0715579383276072 0.0716461621517046 0.0716190569043081 0.0716190758479003 0.0716190910235480 0.0716783212243269 0.0717641235526331 0.0717609732517751 0.0717608769088280 0.0717608905460689 0.0717609016716505 0.0718276865190939 0.0718259767324306 0.0719033491979067 0.0719026082316582 0.0719026175193131 0.0719026321241689 0.0719026374721321 0.0719026279478103 0.0719746644384350 0.0719733287982117 0.0720445062953043 0.0720442781564337 0.0720442814644546 0.0720442884293814 0.0720442912645234 0.0720442824754971 0.0720442422150976 0.0720442064027205 0.0721200593313348 0.0721883082296688 0.0721858646561188 0.0721858669552326 0.0721858624480324 0.0721858660575966 0.0721858592127792 0.0721858419691296 0.0721858135990560 0.0721857706095210 0.0721857065493561 0.0721855198967633 0.0722704871506492 0.0722669293383862 0.0723273758945398 0.0723273718959768 0.0723273707835630 0.0723273624102168 0.0723273482171070 0.0723273378726305 0.0723273194516222 0.0723273008941733 0.0723272568325636 0.0723272214845082 0.0723271783347253 0.0723270852608231 0.0723269243749953 0.0723267358861997 0.0723264318590588 0.0723256884150672 0.0723242942621552 0.0724125211976369 0.0724686883722006 0.0724686191846810 0.0724686206716577 0.0724685215286322 0.0724685216478798 0.0724685258852772 0.0724683789987660 0.0724683830042670 0.0724681834928387 0.0724681792753127 0.0724678980393866 0.0724678905610420 0.0724674950493600 0.0724674830610885 0.0724669275417368 0.0724669094493120 0.0724661300100240 0.0724661034667561 0.0724649695291044 0.0724634380891698 0.0724612355021229 0.0724611583921729 0.0724580423373282 0.0724477859141306 0.0724382711352659 0.0724326804648220 0.0725832046649487 0.0725832068788355 0.0725832090245883 0.0725832111037937 0.0725832131180065 0.0725292722273643;0.189892046320990 0.186438397508207 0.182970296149217 0.179343630078206 0.176588590278237 0.173361715670569 0.170902536400013 0.168632397633801 0.166711883311811 0.165536263423790 0.164635345347787 0.164078624391302 0.163851595321418 0.163600008429020 0.163916771505210 0.164472194260563 0.165110506779948 0.165892937750774 0.166928411539787 0.167891122387674 0.160229006758846 0.160218126530870 0.160153005382360 0.160055876569621 0.156325482443282 0.156215247646985 0.156096515794493 0.156398338957204 0.156322193018410 0.156256217953014 0.161488211175813 0.161472811869088 0.161422838112629 0.161451077552567 0.161428077973783 0.161434899474601 0.164945786581373 0.165034846464807 0.165095154306615 0.164731794291895 0.164866822679258 0.164938553635339 0.165505316082764 0.165222266895979 0.165367778169585 0.165127820987891 0.165283721921739 0.165505172789364 0.165241041400544 0.165464693978215 0.165267281432008 0.165493384959742 0.177038168730469 0.176903072462460 0.176768893918174 0.177047956725689 0.176876527003062 0.176783098149357 0.177063750695125 0.176933113530174 0.176834238514445 0.177126019631946 0.184409019015998 0.184308080359533 0.184216221968907 0.184151080968799 0.184492202007806 0.184427703752852 0.184318817017278 0.184238254039108 0.184173709154946 0.184515198247450 0.184451880006347 0.184391338373210 0.184383040913092 0.184321343861089 0.184259835524974 0.184197006041031 0.192584380264803 0.192577133543899 0.192518428934745 0.192512410925917 0.192449372156366 0.192447970939842 0.192384880999654 0.192333597183616 0.192320834389926 0.192271341968583 0.192657035663430 0.192655110765527 0.192606226885259 0.192591524221290 0.192544418026632 0.192528574624580 0.192485236316573 0.192482297457155 0.192464511710419 0.192421459048847 0.206232876563671 0.206232799060031 0.206212595118179 0.206211428923502 0.206170215823968 0.206169577920611 0.206169647003014 0.206147655222970 0.206145661554240 0.206107178612691 0.206496979629752 0.206497034249216 0.206497078004685 0.206471628887265 0.206443315382385 0.206434252935560 0.206433975786528 0.206434015016676 0.206434047021553 0.206412812547102 0.206405222496055 0.206373130838565 0.206371004157037 0.206371030813965 0.206371072732038 0.206371088081474 0.206371060745278 0.206345483528981 0.206339492910606 0.206308795957362 0.206308142652091 0.206308152125038 0.206308172070010 0.206308180188807 0.206308155020290 0.206308039729410 0.206307937176019 0.206274227353345 0.206252309227625 0.206245327588911 0.206245334157807 0.206245321280093 0.206245331593133 0.206245312036512 0.206245262768942 0.206245181711589 0.206245058884346 0.206244875855303 0.206244342562181 0.206219681872509 0.206208338793785 0.206182581925096 0.206182570526452 0.206182567355310 0.206182543485536 0.206182503025447 0.206182473536601 0.206182421024105 0.206182368122659 0.206182242516880 0.206182141750700 0.206182018744252 0.206181753419854 0.206181294785001 0.206180757462776 0.206179890777097 0.206177771452294 0.206173797161184 0.206140709125275 0.206119553926873 0.206119357139806 0.206119361369149 0.206119079380933 0.206119079720103 0.206119091772349 0.206118673989403 0.206118685382076 0.206118117920355 0.206118105924629 0.206117306017456 0.206117284747124 0.206116159810364 0.206116125712642 0.206114545672993 0.206114494213492 0.206112277288059 0.206112201792191 0.206108976582404 0.206104620774079 0.206098356051068 0.206098136730574 0.206089273870641 0.206060101970033 0.206499764227103 0.206483826904049 0.206447372125590 0.206447378422516 0.206447384525650 0.206447390439505 0.206447396168501 0.207226492078184]';
cs_demand_tmp = (min(cs_comp,repmat(kappa',1,2))*g').*L;
Ps_tmp = ((max((As^(1/alpha)) * L./(cs_demand_tmp.^(1/alpha)) - 1,0.00001)).^(alpha-1))/As;    %Price at which social market clears. make sure that term to the power is positive
Ps = min(Ps,Ps_tmp);  
CS = cs_demand_tmp;

L1 = L;
Ps1 = Ps;
f1 = f;
CS1 = CS;

epsL = 1;
epsf = 1;
epsP = 1;
epsCS = 1;
a0 = a;  
while (epsL > 1e-3 || epsf > 1e-4 || epsP > 1e-3 || epsCS > 1e-3) && iter1 < 200      
    iter1 = iter1 + 1;

    L = gamma*L1 + (1-gamma)*L;
    Ps = gammaP*Ps1 + (1-gammaP)*Ps;
    f = gamma*f1 + (1-gamma)*f;
    CS = gammaP*CS1 + (1-gammaP)*CS;
    a = a0*CS.^d_CS;
    
    %income per capita per period
    B = (((As*Ps).^(alpha/(alpha-1))+As*Ps)./((1+(As*Ps).^(1/(alpha-1))).^alpha)).*(L.^(alpha-1));   
     
    V = NaN(nS,nI,nT,nphi);
    cs_fin = NaN(nS,nI,nT,nphi);
    cs_fin(:,:,nT,1)= repmat(phi(1)*B(end)/Ps(end),nS,nI,1);
    cs_fin(:,:,nT,2)= repmat(phi(2)*B(end)/Ps(end),nS,nI,1);
    % assume that after last period everyone that is I moves to R
    % in last period, consume steady state
    V(:,:,nT,1) = ( (1-phi(1))*log((B(end)-Ps(end)*cs_fin(:,:,nT,1))/(1-phi(1))) + phi(1)*log(cs_fin(:,:,nT,1)/phi(1)) + u_lowerbar)/(1-beta); 
    V(:,:,nT,2) = ( (1-phi(2))*log((B(end)-Ps(end)*cs_fin(:,:,nT,2))/(1-phi(2))) + phi(2)*log(cs_fin(:,:,nT,2)/phi(2)) + u_lowerbar)/(1-beta); 

    for i_phi = 1:nphi   
        for t = nT-1:-1:1       
            cs = XS_mat*phi(i_phi)*B(t)/Ps(t); %consumption social good          
            cr = (1-XS_mat*phi(i_phi))*B(t);    
            degree = b+a(t)*cs;
            S_out = p*f(t)*degree.*S_mat;
            Sprime = max(S_mat-S_out,S_grid(1));
            Iprime = I_mat*(1-lambda_R-lambda_D)+S_out;

            U = -1e10*(cs>kappa(t)) + phi(i_phi)*log(cs) + (1-phi(i_phi))*log(cr) - phi(i_phi)*log(phi(i_phi)) - (1-phi(i_phi))*log(1-phi(i_phi)) + u_lowerbar;
            Wprime = interp2(I_tmp,S_tmp,V(:,:,t+1,i_phi),Iprime,Sprime,'linear',-inf);

            %optimize over consumption
            Wmatrix = U + beta*(1-lambda_D*Itilde_mat).*Wprime;     %
            [Wtemp,cs_ind] = max(Wmatrix,[],3);
            V(:,:,t,i_phi) = Wtemp;
            cs_fin(:,:,t,i_phi) = xs_grid(cs_ind)*phi(i_phi)*B(t)/Ps(t);
        end

         %solve for time path S and I
        for t=1:nT-1
            cs_eq(t,i_phi) = interp2(I_tmp,S_tmp,cs_fin(:,:,t,i_phi),I_phi(t,i_phi),S_phi(t,i_phi),'linear');

            S_out = p*f(t)*(b+a(t)*cs_eq(t,i_phi)).*S_phi(t,i_phi);
            S_phi(t+1,i_phi) = S_phi(t,i_phi) - S_out; 
            I_phi(t+1,i_phi) = I_phi(t,i_phi)*(1-lambda_R-lambda_D)+S_out;
        end
        cs_eq(nT,i_phi) = interp2(I_tmp,S_tmp,cs_fin(:,:,nT,i_phi),I_phi(nT,i_phi),S_phi(nT,i_phi),'linear');
    end
    degree_eq = b+repmat(a,1,nphi).*cs_eq;

    frac_alive = 1-(1-S_phi-I_phi)*lambda_D/(lambda_R+lambda_D);

    L1 = frac_alive*g';         %mass of agents alive (and labor supply)
    f1 = ((degree_eq.*I_phi)*g')./((degree_eq.*frac_alive)*g'); %probability that a person you meet is infected 

    cs_demand = (cs_eq.*frac_alive)*g';
    Ps1 = ((max((As^(1/alpha)) * L1./(cs_demand.^(1/alpha)) - 1,0.00001)).^(alpha-1))/As;    %Price at which social market clears. make sure that term to the power is positive

    CS1 = cs_demand;

    epsL = norm(L1-L);
    epsf = norm(f1-f);
    epsP = norm(Ps1-Ps);
    epsCS = norm(CS1-CS);
%     fprintf('iter big loop=%d epsL=%1.8f epsf=%1.8f epsP=%1.8f epsCS=%1.8f\n',iter1,epsL,epsf,epsP,epsCS) 
end


value1 = interp2(I_tmp,S_tmp,V(:,:,1,1),I_phi(1,1),S_phi(1,1),'linear');
value2 = interp2(I_tmp,S_tmp,V(:,:,1,2),I_phi(1,2),S_phi(1,2),'linear');
        
value_authoritarian = g(1) * value1 +  g(2) * value2;



