function value_liberal = Liberal(x,par)

%%% Calculate welfare when the tax to consumption of the social
%%% good equals x


%% parameters
T = par.T;    %(1 period is a week), so solve for T weeks
dt = par.dt;
beta = par.beta;     %dicounting
phi = par.phi; 
nphi = par.nphi;
g = par.g;  %density phi
epsilon = par.epsilon;     %fraction infected initially
alpha = par.alpha;
As = par.As;   %set A_s such that P_s is 1 in economy with no infections (Ar=L=1)

%disease parameters
p = par.p;
lambda_R = par.lambda_R;
lambda_D = par.lambda_D;

%steady state values
B_ss = par.B_ss;  %Ps=1,L=1,Ar=1
cr_ss = par.cr_ss;
cs_ss = par.cs_ss;
CS_ss = par.CS_ss;

d_CS = par.d_CS;

a = par.a;
b = par.b;

degree_ss = b+a*cs_ss*(CS_ss.^(d_CS));
degree_ss_exp = degree_ss*g';

value_life = par.value_life;    %B_ss is income per capita per week. 10 qaly (= 1 million dollar) corresponds to 16 times GDP per capita
u_lowerbar = (1-beta)*value_life/B_ss - log(B_ss);


%% construct the grid
dS = 0.025;
S_grid = 0:dS:1;     

dI = 0.03;   
I_grid = 0:dI:0.3; 

T_grid = 1:dt:T;

nS = length(S_grid);    %make sure nS  = nR
nI = length(I_grid);
nT = length(T_grid);

xs_grid = 0.2:(0.85/350):1.05;   %share of phi spent on social good

[I_mat,S_mat,XS_mat] = meshgrid(I_grid,S_grid,xs_grid);
I_tmp = I_mat(:,:,1);
S_tmp = S_mat(:,:,1);

alive = min(1-(1-S_mat - I_mat)*lambda_D/(lambda_D+lambda_R),1); 
Itilde_mat = I_mat./alive;



%% value function iteration
%initialize disease states (for forward simulation)
S_phi = NaN(nT,nphi);
S_phi(1,:) = (1-epsilon*degree_ss/degree_ss_exp); %reflects that those with a higher degree are more likely to be infected
I_phi = NaN(nT,nphi);
I_phi(1,:) = epsilon*degree_ss/degree_ss_exp;
cs_eq = NaN(nT,nphi);   %consumption of social good over time for each type
iter1 = 0;
gamma = 1;    %update rate time variables
gammaP = 0.2;  


pol = par.pol;  
x = [x 0];  %make sure in the last period the tax is zero
%construct the policy (for each period)
tau = NaN(nT,1);
t2 = 0;
for i_p = 1:length(pol)
    t1 = t2+1;
    t2 = t1 + pol(i_p) - 1;
    tau(t1:t2) = x(i_p);    
end


% inital guess (from competitive)
f = [0.0250472158845889 0.0302192091753530 0.0356676788122931 0.0411430677568149 0.0464722079783554 0.0513600295055409 0.0557665310574075 0.0595792425030295 0.0627345169815837 0.0651336644470027 0.0668799197373420 0.0680019457549517 0.0685293973137303 0.0684886258211556 0.0679499088382432 0.0670447583303025 0.0657586467318383 0.0641343057101532 0.0623463761821008 0.0603695445426389 0.0580376935188646 0.0552719434597197 0.0525852295725903 0.0499603543533004 0.0472128914184863 0.0441829250709047 0.0413464801535260 0.0386967077206401 0.0362312631742556 0.0339244177904134 0.0316684306575129 0.0293284112801472 0.0271672695585384 0.0251833925291838 0.0233632887177673 0.0216858568264697 0.0201302897013451 0.0186409092148328 0.0172724340315998 0.0160146117443956 0.0148581912004927 0.0137917215772087 0.0128147074199256 0.0119445796117173 0.0111401096072641 0.0103931676149818 0.00969912421348774 0.00905517128167984 0.00845704523536378 0.00790133671074836 0.00738411272568357 0.00690317132081745 0.00645811109403750 0.00608887798027551 0.00574171987250769 0.00541408796828083 0.00510550401839680 0.00481655463150519 0.00454352514764190 0.00428696175667291 0.00404560690998599 0.00381800894962859 0.00360516205261268 0.00343552327014805 0.00327384533488714 0.00312021450139896 0.00297377698805145 0.00283455851351478 0.00270187994396470 0.00257571532204432 0.00245508170769662 0.00234026159574981 0.00223089819784061 0.00212710182370296 0.00202769034398599 0.00193326730310488 0.00184290678436766 0.00175698671314449 0.00167613089113994 0.00161678325250277 0.00155975000664050 0.00150465043369746 0.00145131374231535 0.00140011702413282 0.00135060116543980 0.00130256663093702 0.00125636255325917 0.00121159390291780 0.00116836830282850 0.00112700908698508 0.00108699089336118 0.00104839057669711 0.00101126602963520 0.000975354167621190 0.000940588767430457 0.000907005383371133 0.000874716030959004 0.000843571958936209 0.000814320376049550 0.000806618058531794 0.000798906296333579 0.000791141508812283 0.000783523936464136 0.000775914888439129 0.000768305796892500 0.000760695439652139 0.000753085578435662 0.000745478662631187 0.000737945627189881 0.000730578621353274 0.000723241419676815 0.000715917055895710 0.000708604523540246 0.000701305792488945 0.000694021528283311 0.000686725024186937 0.000679559336295862 0.000672436632865837 0.000665306037315470 0.000658300037558475 0.000651329541814629 0.000644382657130552 0.000637460337431207 0.000630562733585676 0.000623691710091190 0.000616848766383932 0.000610035127389041 0.000603251823531722 0.000596499852915663 0.000589780099745990 0.000583093453288338 0.000576440681296590 0.000569822596045555 0.000563211207537017 0.000556725202288717 0.000550274319826256 0.000543868781114751 0.000537482141990304 0.000531203677261599 0.000524969703575857 0.000518772035620690 0.000512609887065950 0.000506482787155670 0.000500390655977978 0.000494333346147391 0.000488310930394507 0.000482323450459919 0.000476370637834527 0.000470457041562406 0.000464586167470285 0.000458752417405623 0.000452954478686929 0.000447192147384966 0.000441465324967679 0.000435751385672137 0.000430199259165145 0.000424785059409411 0.000419388596087117 0.000414065517364271 0.000408766072058120 0.000403494268872928 0.000398249688498371 0.000393031899271468 0.000387840333131829 0.000382674696818393 0.000377534509988107 0.000372419670581214 0.000367329781429795 0.000362264963337299 0.000357224910618059 0.000352209786941688 0.000347219783444462 0.000342254353201259 0.000337314233030750 0.000332399727399659 0.000327510936118325 0.000322648669788793 0.000317813720706878 0.000313007373365126 0.000308212180112473 0.000303513353859486 0.000298829929539074 0.000294193135504899 0.000289576532396995 0.000284980632077760 0.000280405960158478 0.000275852404092115 0.000271320295920883 0.000266809284095675 0.000262319857495845 0.000257852013919526 0.000253406172766558 0.000248984576519788 0.000244574208357677 0.000240289708998617 0.000236085776901001 0.000231877168358954 0.000227759789053443 0.000223764350147290]';
L = [1 0.999975000000000 0.999945113957856 0.999910051809657 0.999869732651355 0.999824234183882 0.999773933985458 0.999719253845430 0.999660684767189 0.999598797053895 0.999534298654254 0.999467831249010 0.999399983300717 0.999331291303404 0.999262334717272 0.999193597423756 0.999125474986037 0.999058302424717 0.998992470628928 0.998928191132786 0.998865649340023 0.998804972108754 0.998746829460658 0.998691217974167 0.998638105827679 0.998587431748802 0.998539718774067 0.998494801596070 0.998452539437641 0.998412778276476 0.998375373161156 0.998340186366711 0.998307437372999 0.998276956878331 0.998248576348757 0.998222137525695 0.998197504259240 0.998174544381141 0.998153206119065 0.998133369896787 0.998114923564307 0.998097761713520 0.998081790462586 0.998066921855547 0.998053031872319 0.998040052450184 0.998027920031963 0.998016578023557 0.998005971194947 0.997996048948660 0.997986765309799 0.997978077039825 0.997969944042291 0.997962330093354 0.997955145886121 0.997948366326628 0.997941967931055 0.997935929062058 0.997930227809328 0.997924845075185 0.997919762620021 0.997914963278367 0.997910430897849 0.997906150821582 0.997902071184173 0.997898182671978 0.997894475418896 0.997890941019214 0.997887570840677 0.997884357002060 0.997881292244211 0.997878370007839 0.997875583302360 0.997872925780006 0.997870390990455 0.997867973813890 0.997865668444360 0.997863470140951 0.997861373547753 0.997859373874079 0.997857445273644 0.997855584937583 0.997853790425024 0.997852059503465 0.997850389536270 0.997848778496204 0.997847224505371 0.997845725393864 0.997844279447467 0.997842884868271 0.997841539462366 0.997840241667762 0.997838989735054 0.997837781926942 0.997836616830381 0.997835493073472 0.997834409208563 0.997833363724953 0.997832355373843 0.997831382749711 0.997830420149009 0.997829467348465 0.997828524181198 0.997827590340137 0.997826665733216 0.997825750299355 0.997824843994714 0.997823946785220 0.997823058642768 0.997822179542966 0.997821309278108 0.997820447782556 0.997819595018580 0.997818750955692 0.997817915565523 0.997817088822321 0.997816270699628 0.997815461046137 0.997814659816643 0.997813866983924 0.997813082401664 0.997812306040420 0.997811537881938 0.997810777904647 0.997810026085250 0.997809282397086 0.997808546810846 0.997807819295102 0.997807099816705 0.997806388340936 0.997805684831729 0.997804989251732 0.997804301562504 0.997803621724500 0.997802949697030 0.997802285331238 0.997801628596223 0.997800979446083 0.997800337840341 0.997799703654466 0.997799076846546 0.997798457381843 0.997797845224697 0.997797240338614 0.997796642686139 0.997796052229198 0.997795468929032 0.997794892746366 0.997794323641910 0.997793761575755 0.997793206499242 0.997792658368380 0.997792117140853 0.997791582774710 0.997791055228285 0.997790534457329 0.997790020314750 0.997789512647729 0.997789011413177 0.997788516517693 0.997788027933943 0.997787545629700 0.997787069573237 0.997786599733330 0.997786136079427 0.997785678581313 0.997785227209342 0.997784781933968 0.997784342726116 0.997783909556547 0.997783482396381 0.997783061216533 0.997782645987661 0.997782236681078 0.997781833267223 0.997781435716148 0.997781043997796 0.997780658081144 0.997780277934231 0.997779903523773 0.997779534813842 0.997779171687841 0.997778814126213 0.997778462078013 0.997778115525756 0.997777774449809 0.997777438828735 0.997777108640370 0.997776783861481 0.997776464468777 0.997776150438008 0.997775841744652 0.997775538363531 0.997775240267019 0.997774947417945 0.997774659692681 0.997774377004898 0.997774099334834 0.997773826569462]';
Ps = [0.911397301985680 0.898747946956203 0.886089236185145 0.875019584756759 0.863091484608713 0.854212100805230 0.847040799212507 0.841098439567058 0.835008801926923 0.831070659565727 0.828557683595560 0.827235728387882 0.825577121061578 0.825197345656181 0.825952101074792 0.827298795828808 0.827486857812805 0.829940849442880 0.832606338502648 0.835532708670860 0.827973281171922 0.831884323074591 0.835924321298873 0.840270205182499 0.829743769006959 0.834640980536238 0.838796970569823 0.843269477323717 0.847476108512041 0.851472331578290 0.841517383975728 0.845238914837292 0.849170844587029 0.853005275654799 0.856174139067036 0.859467452035231 0.858182904049336 0.860941602315370 0.863683935187370 0.866431013205724 0.868770633248392 0.871074550645431 0.877424148570471 0.879308387800948 0.881246422615049 0.882770799956910 0.884552617085785 0.886131764779374 0.887551811559774 0.888976908709941 0.890286435860280 0.891378962575259 0.902535450146066 0.903512796020170 0.904422397764269 0.905117618360308 0.906185274919138 0.906958307601361 0.907602595037622 0.908389662358171 0.909084735265486 0.909537767035810 0.921956908613653 0.922301007170156 0.923039748761734 0.923383263569180 0.924002940810530 0.924459925235811 0.924800065474491 0.925082442870329 0.925559768959894 0.925888487208230 0.926425912781500 0.926487796954158 0.926964370150709 0.927016146269970 0.927509259481725 0.927693794544822 0.941904171193070 0.942176396449365 0.942390747693063 0.942479152298867 0.942883219171173 0.942952306064794 0.942995288663131 0.943246668070981 0.943248325287879 0.943335362283818 0.943840521339531 0.943850900176891 0.944068602906857 0.944280898332664 0.944311611771367 0.944313099175275 0.944405425021111 0.944600244518954 0.944641156739342 0.944922900078413 0.975403563555955 0.975409987479952 0.975414500777705 0.975553190472221 0.975612303367861 0.975625290715066 0.975628946330707 0.975631070290835 0.975632462141761 0.975632527137722 0.975852924162680 0.975950691074951 0.975970620523052 0.975982891739828 0.975994518702188 0.975997673383707 0.976000863804721 0.976131561190277 0.976183163914934 0.976202816568585 0.976298430817160 0.976357191007071 0.976378617137606 0.976389247190400 0.976389306769968 0.976389326493227 0.976389412251280 0.976389521067095 0.976389511388875 0.976389714311937 0.976389861006773 0.976390199980202 0.976390311411685 0.976390633670770 0.976391737023690 0.976446543288912 0.976551347181217 0.976585045385689 0.976588085644027 0.976683004378873 0.976730547668747 0.976730643790978 0.976731116133254 0.976731206130253 0.976731888660071 0.976732144419401 0.976733100942914 0.976734659693057 0.976735020538245 0.976737918551252 0.976752555967098 0.976779661847531 0.976785700705194 0.976793217334532 0.976802133729370 0.976827633061276 0.976954133918160 0.977376399331720 0.977380839405648 0.977446159403802 0.977486579167124 0.977487052900073 0.977487325460627 0.977488021403735 0.977488073005983 0.977489230729980 0.977489436071266 0.977491120644147 0.977491299935701 0.977493745022734 0.977494510294312 0.977497159036106 0.977501846537116 0.977501913828095 0.977508387159332 0.977517380699402 0.977526842059427 0.977543054718353 0.977565579831958 0.977597165696975 0.977690938166254 0.977771089545977 0.977804453447900 0.977831489371250 0.977833002365306 0.977833555297583 0.977836599441755 0.977837242269314 0.977841589644449 0.977842519175073 0.977849657185211 0.977857213767222 0.977869198226197 0.977902906664787 0.978071808173025 0.978262721954241 0.978582216546350 0.978589331369460 0.978917154041456 0.978917149151121 0.999857440642473]';
CS = [0.0927671232464927 0.0900255728342774 0.0873157841579238 0.0849742058804598 0.0824816251655395 0.0806459580711337 0.0791758952836788 0.0779661260252995 0.0767351000151773 0.0759422688681897 0.0754369837049591 0.0751700834626002 0.0748368669962114 0.0747578332326840 0.0749041619988176 0.0751684144203843 0.0752025833793071 0.0756883131676452 0.0762178617952996 0.0768015307819699 0.0752875299590835 0.0760651131363074 0.0768723002051644 0.0777451824308053 0.0756304377137301 0.0766078996688925 0.0774415328339904 0.0783434526847703 0.0791959448126545 0.0800095550500285 0.0779835988908134 0.0787361455918067 0.0795349246680904 0.0803173703536803 0.0809663376570495 0.0816433614702380 0.0813774208732477 0.0819455616528352 0.0825121062250508 0.0830813987139187 0.0835674843530190 0.0840473921139976 0.0853775402386082 0.0857734728748386 0.0861815968456141 0.0865030591557173 0.0868796273067139 0.0872138996305631 0.0875149271061624 0.0878175024304868 0.0880959110754889 0.0883284083192017 0.0907212591943392 0.0909317698603595 0.0911278614304098 0.0912777713846428 0.0915084378102388 0.0916755080166219 0.0918148071063153 0.0919851899087607 0.0921357444062337 0.0922338295635370 0.0949462907559297 0.0950216464075265 0.0951838424046583 0.0952591685557104 0.0953953307372498 0.0954957404562587 0.0955704551051633 0.0956324723920496 0.0957374954970418 0.0958097943098975 0.0959281774139129 0.0959416551444607 0.0960466814459003 0.0960579520464802 0.0961666969333980 0.0962073186437392 0.0993654269002804 0.0994261996140197 0.0994740375761983 0.0994936955065541 0.0995840319066755 0.0995993815601804 0.0996088896702169 0.0996650768408186 0.0996653398705235 0.0996847315833891 0.0997978112222449 0.0998000393365864 0.0998487369810115 0.0998962356366268 0.0999030323414513 0.0999032815586845 0.0999238997045845 0.0999675055460503 0.0999766033101490 0.100039719443480 0.106961244801274 0.106962648755752 0.106963614455272 0.106995441055833 0.107008965293461 0.107011881602691 0.107012652592363 0.107013071983792 0.107013323847777 0.107013271215852 0.107063907011005 0.107086330931179 0.107090849497901 0.107093607209347 0.107096216899879 0.107096878929236 0.107097550282242 0.107127560625381 0.107139372818599 0.107143833747599 0.107165776875447 0.107179239414658 0.107184110767068 0.107186498137084 0.107186453866204 0.107186400969608 0.107186364081082 0.107186332987934 0.107186275163495 0.107186267112156 0.107186246617205 0.107186271037654 0.107186243716537 0.107186265524884 0.107186467937326 0.107199031534293 0.107223103001094 0.107230808341489 0.107231458955676 0.107253259965696 0.107264155445815 0.107264130100482 0.107264191907331 0.107264166242565 0.107264277676770 0.107264291414483 0.107264467070472 0.107264782106901 0.107264821733092 0.107265446302052 0.107268773911203 0.107274972086163 0.107276321662486 0.107278012178361 0.107280025385119 0.107285858215144 0.107314945330158 0.107412138238241 0.107413123003757 0.107428130615527 0.107437403254743 0.107437475990269 0.107437503080392 0.107437628042306 0.107437605109405 0.107437837564312 0.107437851213886 0.107438206085529 0.107438214679057 0.107438745930794 0.107438890573053 0.107439469512012 0.107440518948091 0.107440504240095 0.107441965869289 0.107444008829460 0.107446159616760 0.107449866281333 0.107455027796645 0.107462276858071 0.107483851118736 0.107502287728606 0.107509948469040 0.107516152114040 0.107516475793431 0.107516578854888 0.107517256668621 0.107517381301778 0.107518360447591 0.107518552118990 0.107520175303452 0.107521895444176 0.107524635864201 0.107532383121501 0.107571281781802 0.107615256922907 0.107688876905917 0.107690498451815 0.107766061644561 0.107766042144534 0.112630747666386]';

L1 = L;
Ps1 = Ps;
f1 = f;
CS1 = CS;

epsL = 1;
epsf = 1;
epsP = 1;
epsCS = 1;
a0 = a;  
while (epsL > 1e-3 || epsf > 1e-4 || epsP > 1e-3 || epsCS > 1e-3) && iter1 < 100      
    iter1 = iter1 + 1;

    L = gamma*L1 + (1-gamma)*L;
    Ps = gammaP*Ps1 + (1-gammaP)*Ps;
    f = gamma*f1 + (1-gamma)*f;
    CS = gammaP*CS1 + (1-gammaP)*CS;
    a = a0*CS.^d_CS;

    %income per capita per period (tax is rebated lump-sum)
    B = (((As*Ps).^(alpha/(alpha-1))+As*Ps.*(1+tau))./((1+(As*Ps).^(1/(alpha-1))).^alpha)).*(L.^(alpha-1));   

    V = NaN(nS,nI,nT,nphi);
    cs_fin = NaN(nS,nI,nT,nphi);
    cs_fin(:,:,nT,1)= repmat(phi(1)*B(end)/((1+tau(end))*Ps(end)),nS,nI,1);
    cs_fin(:,:,nT,2)= repmat(phi(2)*B(end)/((1+tau(end))*Ps(end)),nS,nI,1);
    % assume that after last period everyone that is I moves to R
    % in last period, consume steady state
    V(:,:,nT,1) = ( (1-phi(1))*log((B(end)-((1+tau(end))*Ps(end))*cs_fin(:,:,nT,1))/(1-phi(1))) + phi(1)*log(cs_fin(:,:,nT,1)/phi(1)) + u_lowerbar)/(1-beta); 
    V(:,:,nT,2) = ( (1-phi(2))*log((B(end)-((1+tau(end))*Ps(end))*cs_fin(:,:,nT,2))/(1-phi(2))) + phi(2)*log(cs_fin(:,:,nT,2)/phi(2)) + u_lowerbar)/(1-beta); 
 
    for i_phi = 1:nphi   
        for t = nT-1:-1:1       
            cs = XS_mat*phi(i_phi)*B(t)/((1+tau(t))*Ps(t)); %consumption social good
            cr = (1-XS_mat*phi(i_phi))*B(t);
            degree = b+a(t)*cs;
            S_out = p*f(t)*degree.*S_mat;
            Sprime = max(S_mat-S_out,S_grid(1));
            Iprime = I_mat*(1-lambda_R-lambda_D)+S_out;

            U = phi(i_phi)*log(cs) + (1-phi(i_phi))*log(cr) - phi(i_phi)*log(phi(i_phi)) - (1-phi(i_phi))*log(1-phi(i_phi)) + u_lowerbar;
            Wprime = interp2(I_tmp,S_tmp,V(:,:,t+1,i_phi),Iprime,Sprime,'linear',-inf);

            %optimize over consumption
            Wmatrix = U + beta*(1-lambda_D*Itilde_mat).*Wprime;     %
            [Wtemp,cs_ind] = max(Wmatrix,[],3);
            V(:,:,t,i_phi) = Wtemp;
            cs_fin(:,:,t,i_phi) = xs_grid(cs_ind)*phi(i_phi)*B(t)/((1+tau(t))*Ps(t));
        end

         %solve for time path S and I
        for t=1:nT-1
            cs_eq(t,i_phi) = interp2(I_tmp,S_tmp,cs_fin(:,:,t,i_phi),I_phi(t,i_phi),S_phi(t,i_phi),'linear');

            S_out = p*f(t)*(b+a(t)*cs_eq(t,i_phi)).*S_phi(t,i_phi);
            S_phi(t+1,i_phi) = S_phi(t,i_phi) - S_out; 
            I_phi(t+1,i_phi) = I_phi(t,i_phi)*(1-lambda_R-lambda_D)+S_out;

        end
        cs_eq(nT,i_phi) = interp2(I_tmp,S_tmp,cs_fin(:,:,nT,i_phi),I_phi(nT,i_phi),S_phi(nT,i_phi),'linear');
    end
    degree_eq = b+repmat(a,1,nphi).*cs_eq;

    frac_alive = 1-(1-S_phi-I_phi)*lambda_D/(lambda_R+lambda_D);

    L1 = frac_alive*g';         %mass of agents alive (and labor supply)
    f1 = ((degree_eq.*I_phi)*g')./((degree_eq.*frac_alive)*g'); %probability that a person you meet is infected 

    cs_demand = (cs_eq.*frac_alive)*g';
    Ps1 = ((max((As.^(1/alpha)) .* L1./(cs_demand.^(1/alpha)) - 1,0.00001)).^(alpha-1))./As;    %Price at which social market clears. make sure that term to the power is positive

    CS1 = cs_demand;

    epsL = norm(L1-L);
    epsf = norm(f1-f);
    epsP = norm(Ps1-Ps);
    epsCS = norm(CS1-CS);
%     fprintf('iter big loop=%d epsL=%1.8f epsf=%1.8f epsP=%1.8f epsCS=%1.8f\n',iter1,epsL,epsf,epsP,epsCS) 
end


value1 = interp2(I_tmp,S_tmp,V(:,:,1,1),I_phi(1,1),S_phi(1,1),'linear');
value2 = interp2(I_tmp,S_tmp,V(:,:,1,2),I_phi(1,2),S_phi(1,2),'linear');
        
value_liberal = g(1) * value1 +  g(2) * value2;



