function Value_social = Social_planner(x,par)

%%% Calculate welfare for a stream of consumption of the social good x


%% parameters
dt = par.dt;

beta = par.beta;      %dicounting
  
phi = par.phi; 
nphi = par.nphi;
g = par.g;  %density phi
g = g/sum(g);
E_phi = par.E_phi; %expectation phi
epsilon = par.epsilon;     %fraction infected initially

alpha = par.alpha;
As = (E_phi/(1-E_phi))^(1-alpha);   %set A_s such that P_s is 1 in economy with no infections (Ar=L=1)

%disease parameters
p = par.p;

lambda_R = par.lambda_R;
lambda_D = par.lambda_D;

ICU_limit = par.ICU_limit;
death_slope = par.death_slope;


nT = par.nT;


%% solve steady state (pre-disease onset) and value of life
B_ss =  par.B_ss;
cr_ss = par.cr_ss;
cs_ss = par.cs_ss;
CS_ss = par.CS_ss;

d_CS = par.d_CS;

a = par.a;
b = par.b;

degree_ss = b+a*cs_ss*(CS_ss.^(d_CS));
degree_ss_exp = degree_ss*g';

value_life = par.value_life;

u_lowerbar = (1-beta)*value_life/B_ss - log(B_ss);

u_ss = (1-phi).*log(cr_ss./(1-phi)) + phi.*log(cs_ss./phi) + u_lowerbar;


% time path of consumption social good for which we are calculating welfare
c_s = [x(1:nT)  x(nT+1:end)];

%% evoluation of disease
S_phi = NaN(nT,nphi);
S_phi(1,:) = (1-epsilon*degree_ss/degree_ss_exp); %reflects that those with a higher degree are more likely to be infected
R_phi = NaN(nT,nphi);
R_phi(1,:) = 0;
I_phi = NaN(nT,nphi);
I_phi(1,:) = 1-S_phi(1,:);

frac_alive = NaN(nT,nphi);
f = NaN(nT,1);
C_S = NaN(nT,1);
degree = NaN(nT,2);
L = NaN(nT,1);

% iterate evolution of disease forward
for t=1:nT-1 
    frac_alive(t,:) = S_phi(t,:) + I_phi(t,:) + R_phi(t,:);
    
    L(t) = frac_alive(t,:)*g';  %labor supply
    C_S(t) = (c_s(t,:).*frac_alive(t,:))*g';   %aggregate consumption
    degree(t,:) = b + a*(C_S(t).^(d_CS)).*c_s(t,:);
    
    f(t) = ((I_phi(t,:).*degree(t,:))*g')/((degree(t,:).*frac_alive(t,:))*g');  
    
    s_out = p*f(t)*degree(t,:).*S_phi(t,:);
    
    S_phi(t+1,:) = S_phi(t,:)-s_out;
    
    I = I_phi(t,:)*g';  
    lambda_D_tmp  = lambda_D + death_slope*(max(1-ICU_limit/I,0))^2;    %change in death rate depending on ICU limit
    
    I_phi(t+1,:) = (1-(lambda_R+lambda_D_tmp))*I_phi(t,:)+s_out;
    R_phi(t+1,:) = R_phi(t,:)+lambda_R*I_phi(t,:);
end
frac_alive(nT,:) = S_phi(nT,:) + I_phi(nT,:) + R_phi(nT,:);
% f(nT) = ((I_phi(nT,:).*degree(nT,:))*g')/((degree(nT,:).*frac_alive(nT,:))*g');  
L(nT) = frac_alive(nT,:)*g';  %labor supply
C_S(nT) = (c_s(nT,:).*frac_alive(nT,:))*g';   %aggregate consumption

% death = (1-frac_alive)*g';
% L = frac_alive*g';  %labor supply
ls = (C_S/As).^(1/alpha);   %labor social sector
lr = L-ls;         %labor regular sector

Ps = ((lr./ls).^(alpha-1))/As;   %from FOC firm
B = (As*Ps.*(ls).^alpha + lr.^alpha)./L;

c_r = repmat(B,1,nphi) - repmat(Ps,1,nphi).*c_s;    %Ps is the price firms get, not the price that people are charged


%% Calculate welfare
% value at end of time horizon (assuming that consumption reaches new
% steady state level)
u_ss_end = (1-phi).*log(c_r(end,:)./(1-phi)) + phi.*log(c_s(end,:)./phi) + u_lowerbar;
V_ss_end = u_ss_end/(1-beta); 

%flow utility during epidemic
phi_long = repmat(phi,nT,1);
u_flow = ((1-phi_long).*log(c_r./(1-phi_long)) + phi_long.*log(c_s./phi_long) + u_lowerbar);

% discount factor as a vector
discount = beta.^(0:nT-1);
discount_end = beta*discount(end);

%Value
Value = ((u_flow.*frac_alive)'*discount')' + discount_end*frac_alive(nT,:).*V_ss_end;


Value_social = Value * g';

